/* Copyright (c) 2007 Analog Devices, Inc. All rights reserved.

ADI_CED1_dll.h and ADI_CED1_dll.c can be used to explicitly link 
to ADI_CED1a.dll

*/

#include"ADI_CED1_dll.h"

/* link_to_adi_ced1_dll() is used to explicitly link to the ADI_CED1a.dll. It
   loads the libary and fills the ced structure with a handle to the dll and
   and function pointers to all the exposed functions of the dll. If an error
   is encountered TRUE is returned with FALSE returned if the link was 
   successful. */
long link_to_adi_ced1_dll( ADI_CED1 *ced )
{
	long error = FALSE;

	ced->hdll = LoadLibrary("ADI_CED1a");
	if( ced->hdll == NULL )
		error = TRUE;
	else
	{
		ced->search_for_boards = (SEARCH_FOR_BOARDS)GetProcAddress( ced->hdll,
			"?Search_For_Boards@@YGHAAHQAK@Z" );
		
		if( ced->search_for_boards == NULL )
			error = TRUE;
		
		ced->program_board = (PROGRAM_BOARD)GetProcAddress( ced->hdll,
			"?Program_Board@@YGHKPBD@Z"	);
		
		if( ced->program_board == NULL )
			error = TRUE;
		
		ced->identify_board = (IDENTIFY_BOARD)GetProcAddress( ced->hdll,
			"?Identify_Board@@YGHK@Z" );
		
		if( ced->identify_board == NULL )
			error = TRUE;
		
		ced->configure_power_supplies = (CONFIGURE_POWER_SUPPLIES)GetProcAddress(
			ced->hdll, "?Configure_Power_Supplies@@YGHKHHHG@Z" );
		
		if( ced->configure_power_supplies == NULL )
			error = TRUE;
		
		ced->read_power_supplies = (READ_POWER_SUPPLIES)GetProcAddress(
			ced->hdll, "?Read_Power_Supplies@@YGHKQANI@Z" );
		
		if( ced->read_power_supplies == NULL )
			error = TRUE;
		
		ced->check_data_ready = (CHECK_DATA_READY)GetProcAddress( ced->hdll,
			"?Check_Data_Ready@@YGHKAAH@Z" );
		
		if( ced->check_data_ready == NULL )
			error = TRUE;
		
		ced->reset = (RESET)GetProcAddress( ced->hdll, "?Reset@@YGHK@Z" );
		
		if( ced->reset == NULL )
			error = TRUE;
		
		ced->manual_send_to_ced = (MANUAL_SEND_TO_CED)GetProcAddress( ced->hdll,
			"?Manual_Send_To_CED@@YGHKGQAGI@Z" );

		if( ced->manual_send_to_ced == NULL )
			error = TRUE;
		
		ced->manual_receive_from_ced = (MANUAL_RECEIVE_FROM_CED)GetProcAddress(
			ced->hdll, "?Manual_Receive_From_CED@@YGHKGQAGI@Z" );
		
		if( ced->manual_receive_from_ced == NULL )
			error = TRUE;
	}

	return error;
}

/* free_adi_ced1_dll() frees the handle to ADI_CED1a.dll created by
   link_to_adi_ced1_dll() */
void free_adi_ced1_dll( ADI_CED1 ced )
{
	FreeLibrary( ced.hdll );
}
